﻿///
/// SevenZip++ の共通ヘッダファイル。
///

#if       !defined(INCLUDED_SZ_COMMON)
#define            INCLUDED_SZ_COMMON

// クライアントが 7-Zip ヘッダをインクルードする際に各種の define をしておかなくてもよいようにマクロを定義。

#if       !defined(COMPRESS_MT)
#define            COMPRESS_MT
#endif // !defined(COMPRESS_MT)

#if       !defined(WIN_LONG_PATH)
#define            WIN_LONG_PATH
#endif // !defined(WIN_LONG_PATH)

#if       !defined(EXTERNAL_LZMA)
#define            EXTERNAL_LZMA
#endif // !defined(EXTERNAL_LZMA)

#if       !defined(EXTERNAL_CODECS)
#define            EXTERNAL_CODECS
#endif // !defined(EXTERNAL_CODECS)

#if       !defined(_7ZIP_LARGE_PAGES)
#define            _7ZIP_LARGE_PAGES
#endif // !defined(_7ZIP_LARGE_PAGES)

#if       !defined(SUPPORT_DEVICE_FILE)
#define            SUPPORT_DEVICE_FILE
#endif // !defined(SUPPORT_DEVICE_FILE)

/// 名前空間を開始するマクロ。
#define   SZ_NS_BEG(x)  namespace x {

/// 名前空間を終了するマクロ。
#define   SZ_NS_END(x)  }

/// 無名名前空間を開始するマクロ。
#define   SZ_AN_BEG     namespace {

/// 無名名前空間を終了するマクロ。
#define   SZ_AN_END     }

/// 呼び出し規約や名前付け規約の調整用マクロ。
#if       !defined(SZ_SPEC)
#if         defined(SZPP_EXPORTS)
#define            SZ_SPEC  __declspec(dllexport)
#elif       defined(SZPP_IMPORTS)
#define            SZ_SPEC  __declspec(dllimport)
#else
#define            SZ_SPEC
#endif //   defined(SZPP_EXPORTS)
#endif // !defined(SZ_SPEC)

#if       defined(_WIN32) || defined(_WIN64)
#include  <szWindowsConfig.hpp>
#endif // defined(_WIN32) || defined(_WIN64)

#include  <szTypes.hpp>
#include  <szStl.hpp>
#include  <szBoost.hpp>
#include  <szGetText.hpp>

#if       defined(_WIN32) || defined(_WIN64)
#include  <szWindows.hpp>
#endif // defined(_WIN32) || defined(_WIN64)

/// <summary>
/// SevenZip++ が提供する型のほとんどすべてを含む名前空間。
/// </summary>
/// <notes>
/// 型名の先頭に sz が付くものと付かないものがあるが、基本的には szpp 名前空間に含まれる型には sz を付けない。
/// そして、ルート名前空間で直接定義される型には、型名の先頭に原則的として sz や SZ を付ける。
/// ただし、u32 や index_t のように頻繁に利用され、かつ型名が短いプリミティブ型名は例外とする。
/// </notes>

SZ_NS_BEG(szpp)
SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_COMMON)
